
#include <M5Unified.h>
#include <M5PM1.h>
#include <Wire.h>
#include "./bmi270/src/bmi270.h"
#include "driver/rtc_io.h"

static BMI270_Class* bmi270 = nullptr;

M5PM1 pm1;

void setup(void)
{
    M5.begin();
    M5.Display.setRotation(1);
    Serial.begin(115200);
    auto pin_num_sda = M5.getPin(m5::pin_name_t::in_i2c_sda);
    auto pin_num_scl = M5.getPin(m5::pin_name_t::in_i2c_scl);
    M5_LOGI("getPin: SDA:%u SCL:%u", pin_num_sda, pin_num_scl);

    // Initialize PM1
    m5pm1_err_t err = pm1.begin(&Wire, M5PM1_DEFAULT_ADDR, pin_num_sda, pin_num_scl, M5PM1_I2C_FREQ_100K);

    if (err == M5PM1_OK) {
        Serial.println("PM1 initialization successful");
        pm1.irqClearGpioAll();
        pm1.irqClearSysAll();
        pm1.irqClearBtnAll();

        pm1.irqSetGpioMaskAll(M5PM1_IRQ_MASK_ENABLE);
        pm1.irqSetSysMaskAll(M5PM1_IRQ_MASK_ENABLE);
        pm1.irqSetBtnMaskAll(M5PM1_IRQ_MASK_ENABLE);

        pm1.irqSetGpioMask(M5PM1_IRQ_GPIO4, M5PM1_IRQ_MASK_DISABLE);
        pm1.gpioSetMode(M5PM1_GPIO_NUM_4, M5PM1_GPIO_MODE_INPUT);
        pm1.gpioSetPull(M5PM1_GPIO_NUM_4, M5PM1_GPIO_PULL_UP);

        pm1.gpioSetMode(M5PM1_GPIO_NUM_1, M5PM1_GPIO_MODE_OUTPUT);
        pm1.gpioSetDrive(M5PM1_GPIO_NUM_1, M5PM1_GPIO_DRIVE_PUSHPULL);
        pm1.gpioSetFunc(M5PM1_GPIO_NUM_1, M5PM1_GPIO_FUNC_IRQ);

    } else {
        Serial.printf("PM1 initialization failed, error code: %d\n", err);
    }

    // Initialize BMI270
    bmi270 = new BMI270_Class();
    bmi270->setWire(&Wire);

    if (bmi270->init()) {
        Serial.println("BMI270 initialization successful");
        M5.Display.fillScreen(BLACK);
        M5.Display.setTextSize(2);
        M5.Display.setTextColor(WHITE);
        M5.Display.setCursor(0, 10);
        M5.Display.println("IMU IRQ Test");
        M5.Display.println("Press BtnA to Setup");
        M5.Display.println("Then Shake");
    } else {
        Serial.println("BMI270 initialization failed");
        delete bmi270;
        bmi270 = nullptr;
    }
}

void ARDUINO_ISR_ATTR pm1_irq_handler()
{
    Serial.println("PM1 IRQ triggered");
    M5.Display.println("PM1 IRQ triggered");
}

void loop(void)
{
    M5.update();
    if (M5.BtnA.wasPressed()) {
        pm1.irqClearGpioAll();
        pm1.irqClearSysAll();
        pm1.irqClearBtnAll();
        // Configure BMI270 any motion interrupt
        if (bmi270 != nullptr) {
            if (bmi270->enableAnyMotionInterrupt(0xA0, 0x0A)) {
                Serial.println("BMI270 AnyMotionInterrupt enabled successfully");
            } else {
                Serial.println("Failed to enable BMI270 AnyMotionInterrupt");
            }
        } else {
            Serial.println("BMI270 not initialized");
        }
        M5.Display.fillScreen(BLACK);
        M5.Display.setCursor(0, 10);
        M5.Display.println("Now Shake!");

        pinMode(GPIO_NUM_13, INPUT_PULLUP);
        attachInterrupt(GPIO_NUM_13, pm1_irq_handler, FALLING);

        // esp_sleep_enable_ext0_wakeup(GPIO_NUM_13, 0);  // 0 = Low
        // rtc_gpio_pullup_en(GPIO_NUM_13);
        // Serial.println("Going to sleep now");
        // esp_deep_sleep_start();
    }
}
