
#include <M5Unified.h>
#include <M5PM1.h>
#include <Wire.h>
#include "./bmi270/src/bmi270.h"

static BMI270_Class* bmi270 = nullptr;

M5PM1 pm1;

void setup(void)
{
    M5.begin();
    M5.Display.setRotation(1);
    Serial.begin(115200);
    auto pin_num_sda = M5.getPin(m5::pin_name_t::in_i2c_sda);
    auto pin_num_scl = M5.getPin(m5::pin_name_t::in_i2c_scl);
    M5_LOGI("getPin: SDA:%u SCL:%u", pin_num_sda, pin_num_scl);
    Wire.end();
    Wire.begin(pin_num_sda, pin_num_scl, 100000U);

    // Initialize PM1
    m5pm1_err_t err = pm1.begin(&Wire, M5PM1_DEFAULT_ADDR, pin_num_sda, pin_num_scl, M5PM1_I2C_FREQ_100K);

    if (err == M5PM1_OK) {
        Serial.println("PM1 initialization successful");
        pm1.gpioSetWakeEnable(M5PM1_GPIO_NUM_4, true);
        pm1.gpioSetWakeEdge(M5PM1_GPIO_NUM_4, M5PM1_GPIO_WAKE_FALLING);  // Falling edge
    } else {
        Serial.printf("PM1 initialization failed, error code: %d\n", err);
    }

    // Initialize BMI270
    bmi270 = new BMI270_Class();
    bmi270->setWire(&Wire);

    if (bmi270->init()) {
        Serial.println("BMI270 initialization successful");
        M5.Display.fillScreen(BLACK);
        M5.Display.setTextSize(2);
        M5.Display.setTextColor(WHITE);
        M5.Display.setCursor(0, 10);
        M5.Display.println("IMU Wakeup Test");
        M5.Display.println("Press BtnA to Sleep");
        M5.Display.println("Shake to wake up");
    } else {
        Serial.println("BMI270 initialization failed");
        delete bmi270;
        bmi270 = nullptr;
    }
}

void loop(void)
{
    M5.update();
    if (M5.BtnA.wasPressed()) {
        // Configure BMI270 any motion interrupt
        if (bmi270 != nullptr) {
            if (bmi270->enableAnyMotionInterrupt(0xA0, 0x0A)) {
                Serial.println("BMI270 AnyMotionInterrupt enabled successfully");
            } else {
                Serial.println("Failed to enable BMI270 AnyMotionInterrupt");
            }
        } else {
            Serial.println("BMI270 not initialized");
        }
        M5.Display.fillScreen(BLACK);
        M5.Display.setCursor(0, 10);
        M5.Display.println("Power OFF");
        delay(1000);
        // Shutdown
        pm1.setLdoEnable(true);
        pm1.ldoSetPowerHold(true);
        pm1.setLedEnLevel(true);
        pm1.shutdown();
    }
}
