# BMI270 驱动 Wire.h 迁移指南

## 概览
BMI270 驱动已从 `i2c_bus` 库迁移到 Arduino 标准的 `Wire.h` 库。只有数据读写接口部分进行了改动，其他功能保持不变。

## 改动内容

### 头文件变更 (bmi270.h)
1. **移除**：`#include <driver/i2c.h>`
2. **添加**：`#include <Wire.h>`
3. **添加私有成员**：`TwoWire* _wire = nullptr;` 用于存储 Wire 实例指针
4. **添加新方法**：`void setWire(TwoWire* wire);` 用于初始化 Wire 实例

### 实现文件变更 (bmi270.cpp)
1. **移除**：`#include <i2c_bus.h>` 和相关的外部设备句柄
2. **添加**：`setWire()` 方法实现，用于注入 Wire 实例
3. **修改**：`bmi2_i2c_read()` - 改用 Wire 的标准 I2C 读操作
4. **修改**：`bmi2_i2c_write()` - 改用 Wire 的标准 I2C 写操作

## 使用方式

### 初始化示例

```cpp
#include "./bmi270/src/bmi270.h"
#include <Wire.h>

static BMI270_Class* bmi270 = nullptr;

void setup(void)
{
    // 初始化 Wire（已配置好 SDA、SCL 和速率）
    Wire.begin(pin_num_sda, pin_num_scl, 100000U);
    
    // 创建 BMI270 实例
    bmi270 = new BMI270_Class();
    
    // 设置 Wire 实例
    bmi270->setWire(&Wire);
    
    // 初始化传感器
    if (!bmi270->init()) {
        Serial.println("BMI270 initialization failed!");
        return;
    }
    
    Serial.println("BMI270 initialized successfully!");
}
```

## Wire 操作细节

### 读操作流程
1. 使用 `beginTransmission()` 选择设备地址
2. 使用 `write()` 写入寄存器地址
3. 使用 `endTransmission(false)` 发送停止条件（但不释放总线）
4. 使用 `requestFrom()` 请求指定长度的数据
5. 使用 `available()` 和 `read()` 读取数据

### 写操作流程
1. 使用 `beginTransmission()` 选择设备地址
2. 使用 `write()` 写入寄存器地址
3. 使用 `write()` 循环写入数据字节
4. 使用 `endTransmission(true)` 发送停止条件（释放总线）

## 兼容性

- **移除的依赖**：不再需要 `i2c_bus` 库
- **新增依赖**：需要 Arduino 的 `Wire` 库（通常内置）
- **传感器 API**：没有变更，所有传感器功能保持不变
- **错误处理**：保持原有的错误返回机制 (返回 -1 表示失败)

## 可选：外设初始化配置

如果需要配置 BMI270 的工作参数，可以继承 `BMI270_Class` 类并覆盖 `configure_sensor()` 方法：

```cpp
class CustomBMI270 : public BMI270_Class {
protected:
    int8_t configure_sensor(struct bmi2_dev* dev) override {
        // 自定义配置代码
        return BMI2_OK;
    }
};
```

## 注意事项

1. **Wire 实例必须先初始化**：在调用 `setWire()` 之前，Wire 实例必须已调用 `begin()`
2. **单例模式**：驱动内部使用单例来管理类实例，确保只有一个 BMI270 对象
3. **读写长度限制**：单次读写不超过 32 字节（由 BMI270 传感器 API 要求）
4. **辅助设备（BMM150）**：磁力计的读写操作通过 BMI270 的 AUX 接口进行，不直接使用 Wire

