#include <M5Unified.h>

const int SPEAKER_PIN = 26;
const int SD_PIN = 0;
const int PWM_CHANNEL = 0;
const int PWM_RESOLUTION = 10;  // 10-bit resolution (0-1023)
const int PWM_FREQ = 40000;     // 40kHz carrier frequency

void setup() {
    M5.begin();
    
    // Enable speaker
    pinMode(SD_PIN, OUTPUT);
    digitalWrite(SD_PIN, HIGH);
    
    // Configure LEDC PWM
    ledcAttach(SPEAKER_PIN, PWM_FREQ, PWM_RESOLUTION);
    M5.Display.setRotation(1);  // Depends on the direction of M5StickC-Plus2 be held
    M5.Display.setCursor(40, 60, 2);
    M5.Display.print("Press BtnA to play Audio");
}

void playTone(int frequency, int duration) {
    // Calculate duty cycle for 50% square wave
    int dutyCycle = (1 << (PWM_RESOLUTION - 1));  // 512 for 10-bit
    
    // Set PWM frequency to audio frequency
    ledcChangeFrequency(SPEAKER_PIN, frequency, PWM_RESOLUTION);
    ledcWrite(SPEAKER_PIN, dutyCycle);
    
    delay(duration);
    
    // Stop tone
    ledcWrite(SPEAKER_PIN, 0);
}

void loop() {
  M5.update();

  if (M5.BtnA.wasPressed()) {
    // Play musical notes
    playTone(262, 500);  // C4
    delay(100);
    playTone(294, 500);  // D4
    delay(100);
    playTone(330, 500);  // E4
    delay(100);
    playTone(349, 500);  // F4
    delay(100);
    playTone(392, 500);  // G4
    delay(1000);
  }
}
