#include <M5Unified.h>

extern const unsigned char m5stack_startup_music[];
extern const unsigned int m5stack_startup_music_len;

const int HAT_SPK_ENABLE_PIN = 0;
const int HAT_SPK_AUDIO_PIN = 26;

void setup() {
    auto cfg = M5.config();
    cfg.external_speaker.hat_spk = true;
    M5.begin(cfg);
    
    // Enable speaker
    pinMode(HAT_SPK_ENABLE_PIN, OUTPUT);
    digitalWrite(HAT_SPK_ENABLE_PIN, HIGH);
    
    // Configure Speaker to use GPIO26（Hat SPK）
    auto spk_cfg = M5.Speaker.config();
    spk_cfg.pin_data_out = HAT_SPK_AUDIO_PIN;
    spk_cfg.sample_rate = 8000;
    spk_cfg.task_pinned_core = APP_CPU_NUM;
    M5.Speaker.config(spk_cfg);
    M5.Speaker.begin();
    
    M5.Display.setRotation(1);
    M5.Display.setCursor(40, 60, 2);
    M5.Display.print("Press BtnA to play");
}

void playMusic() {
    M5.Display.clear();
    M5.Display.setCursor(40, 60, 2);
    M5.Display.print("Playing...");
    
    // Use Hat SPK to play audio
    M5.Speaker.playRaw(
        m5stack_startup_music,
        m5stack_startup_music_len,
        8000,
        false,
        1,
        0
    );
    
    while (M5.Speaker.isPlaying()) {
        M5.update();
        if (M5.BtnA.wasPressed()) {
            M5.Speaker.stop();
            break;
        }
        delay(10);
    }
    
    M5.Display.clear();
    M5.Display.setCursor(40, 60, 2);
    M5.Display.print("Press BtnA to play");
}

void loop() {
    M5.update();
    if (M5.BtnA.wasPressed()) {
        playMusic();
    }
    delay(10);
}
